#  Copyright (c) 2019 Canonical Ltd.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#  USA

from aptsources.distro import get_distro

from softwareproperties.sourceslist import SourcesListShortcutHandler


class URIShortcutHandler(SourcesListShortcutHandler):
    def __init__(self, shortcut, **kwargs):
        (uri, _, comps) = shortcut.strip().partition(' ')

        # can't use self.codename here, as we haven't called superclass constructor yet
        distro = get_distro()
        codename = kwargs.get('codename', distro.codename)
        pocket = kwargs.get('pocket')
        dist = codename
        if pocket:
            dist = '%s-%s' % (dist, pocket)

        line = ('%s %s %s %s' % (distro.binary_type, uri, dist, comps or 'main'))

        super(URIShortcutHandler, self).__init__(line, ignore_line_comps=not comps, **kwargs)


# vi: ts=4 expandtab
