/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntu.apport;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;

public class ApportUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            return;
        }
        HashMap hashMap = this.getProblemReport(thread, throwable);
        try {
            String string = System.getenv("APPORT_JAVA_EXCEPTION_HANDLER");
            if (string == null) {
                string = "/usr/share/apport/java_uncaught_exception";
            }
            Process process = new ProcessBuilder(string).start();
            OutputStream outputStream = process.getOutputStream();
            this.writeProblemReport(outputStream, hashMap);
            outputStream.close();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            System.out.println("could not call java_uncaught_exception");
        }
        System.err.print("Exception in thread \"" + thread.getName() + "\" ");
        throwable.printStackTrace(System.err);
    }

    public HashMap getProblemReport(Thread thread, Throwable throwable) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        hashMap.put("StackTrace", stringWriter.toString());
        hashMap.put("MainClassUrl", ApportUncaughtExceptionHandler.mainClassUrl(throwable));
        return hashMap;
    }

    public void writeProblemReport(OutputStream outputStream, HashMap hashMap) throws IOException {
        StringWriter stringWriter = new StringWriter();
        for (Object k : hashMap.keySet()) {
            String string = (String)k;
            String string2 = (String)hashMap.get(k);
            stringWriter.write(string);
            stringWriter.write("\u0000");
            stringWriter.write(string2);
            stringWriter.write("\u0000");
        }
        outputStream.write(stringWriter.toString().getBytes());
    }

    public static String mainClassUrl(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = stackTraceElementArray[stackTraceElementArray.length - 1].getClassName();
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        string = string.replace('.', '/');
        string = string + ".class";
        URL uRL = new ApportUncaughtExceptionHandler().getClass().getResource(string);
        return uRL.toString();
    }

    public static void install() {
        Thread.setDefaultUncaughtExceptionHandler(new ApportUncaughtExceptionHandler());
    }
}

